package ru.yandex.avia.booking.partners.gateways.aeroflot.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Getter;

import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = AeroflotTicketCouponStatusCode.AeroflotCouponStatusCodeDeserializationConverter.class)
public enum AeroflotTicketCouponStatusCode implements ValueBasedEnum<String> {
    OK("Y"),
    VOIDED("V"),
    FLOWN("F"),
    CHECKED_IN("C"),
    REFUNDED("R"),
    EXCHANGED("E"),
    AIRPORT_CONTROL("N");

    private final String value;

    AeroflotTicketCouponStatusCode(String value) {
        this.value = value;
    }

    static class AeroflotCouponStatusCodeDeserializationConverter
            extends ValueBasedEnumDeserializationConverter<String, AeroflotTicketCouponStatusCode> {
    }
}
