package ru.yandex.avia.booking.partners.gateways.aeroflot.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Getter;

import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = AeroflotTicketDocTypeCode.AeroflotTicketDocTypeCodeDeserializationConverter.class)
public enum AeroflotTicketDocTypeCode implements ValueBasedEnum<String> {
    TICKET("T"),
    SERVICE("J"),
    EMD_STANDALONE("Y"),
    RETURN_RECEIPT("700");

    private final String value;

    AeroflotTicketDocTypeCode(String value) {
        this.value = value;
    }

    static class AeroflotTicketDocTypeCodeDeserializationConverter
            extends ValueBasedEnumDeserializationConverter<String, AeroflotTicketDocTypeCode> {
    }
}
