package ru.yandex.avia.booking.partners.gateways.aeroflot.model;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

import com.google.common.base.Preconditions;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.Accessors;
import org.javamoney.moneta.Money;

@Data
@Builder(toBuilder = true)
@Accessors(chain = true)
@NoArgsConstructor // json support
@AllArgsConstructor
public class AeroflotTotalOffer implements AeroflotEntity {
    //@NonNull
    private String id;
    //@NonNull
    private Money totalPrice;
    //@NonNull
    private String disclosureUrl;
    //@NonNull
    private List<AeroflotCategoryOffer> categoryOffers;
    //@NonNull
    private List<AeroflotApplicableSegmentRef> segmentRefs;

    // v3 model extension
    private String ownerCode;

    @NonNull
    public AeroflotCategoryOffer getCategoryOfferFor(@NonNull String travellerId) {
        List<AeroflotCategoryOffer> offers = categoryOffers
                .stream().filter(co -> co.getTravellerId().equals(travellerId)).collect(Collectors.toList());
        Preconditions.checkArgument(offers.size() == 1,
                "exactly one category offer is expected for the traveller: traveller=%s, offers=%s",
                travellerId, offers);
        return offers.get(0);
    }

    @NonNull
    public AeroflotApplicableSegmentRef getSegmentRef(@NonNull String segmentId) {
        for (AeroflotApplicableSegmentRef ref : segmentRefs) {
            if (ref.getSegmentId().equals(segmentId)) {
                return ref;
            }
        }
        throw new NoSuchElementException("segmentRef: segmentId=" + segmentId);
    }
}
