package ru.yandex.avia.booking.partners.gateways.aeroflot.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class SearchData {
    private String qid;
    private String externalBookingUrl;
    private SearchParams searchParams;
    private String variantTag;

    @Data
    @Accessors(chain = true)
    @Builder(toBuilder = true)
    @NoArgsConstructor
    @AllArgsConstructor
    public static class SearchParams {
        private String nationalVersion;
        private String lang;
        private String klass;
        private String pointFrom;
        private String pointTo;
    }
}
