package ru.yandex.avia.booking.partners.gateways.aeroflot.v3;

import java.util.List;
import java.util.stream.Collectors;

import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model.AirShoppingRs;
import ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model.Offer;

@Slf4j
public class AeroflotNdcApiV3Helper {
    public static Offer findOfferById(AirShoppingRs airShoppingRs, String offerId) {
        List<Offer> offers = airShoppingRs.getResponse()
                .getOffersGroup().getCarrierOffers().getOffer().stream()
                .filter(o -> o.getOfferID().equals(offerId))
                .collect(Collectors.toList());
        Preconditions.checkArgument(offers.size() == 1,
                "Unexpected number of offers with id %s: %s", offerId, offers.size());
        return offers.get(0);
    }

    public static String extractPnrFromOrderIdSafe(String orderId) {
        try {
            // see TRAVELBACK-1765 for more details
            Preconditions.checkState(orderId.matches("SU555[A-Z]{6}-.*"),
                    "Expected the 'SU555(PNRPNR)-...' order id format but got '%s'", orderId);
            int pnrStartIdx = "SU555".length();
            int pnrLength = 6;
            return orderId.substring(pnrStartIdx, pnrStartIdx + pnrLength);
        } catch (Exception e) {
            log.warn("Aeroflot OrderID parsing error", e);
            return null;
        }
    }
}
