package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JacksonXmlRootElement(localName = "IATA_AirShoppingRQ")
public class AirShoppingRq {
    /**
     * The xmlns attribute is specified this way as if it's passed as the 'namespace' attribute of the
     * JacksonXmlRootElement annotation above, it force all its children go with an empty overriding namespace.
     * E.g.: <pre>&lt;Party xmlns=""&gt;...;</pre>
     * <p>More details are available <a href="https://github.com/FasterXML/jackson-dataformat-xml/issues/18">here</a>
     */
    @JacksonXmlProperty(isAttribute = true, localName = "xmlns")
    private final String xmlns = "http://www.iata.org/IATA/2015/00/2018.2/IATA_AirShoppingRQ";

    private final Party party;
    private final PayloadAttributes payloadAttributes;
    private final PointOfSale pointOfSale;
    private final AirShoppingRqBody request;
}
