package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import javax.xml.bind.annotation.XmlAttribute;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = AirShoppingRs.AirShoppingRsBuilder.class)
@JacksonXmlRootElement(localName = "IATA_AirShoppingRS")
public class AirShoppingRs implements ApiDataXmlRoot<AirShoppingRs> {
    public static final String SCHEMA = "http://www.iata.org/IATA/2015/00/2018.2/IATA_AirShoppingRS";

    private final AirShoppingRsBody response;
    private final MessageDoc messageDoc;
    private final StatusMessage error;
    private final PayloadAttributes payloadAttributes;
    @XmlAttribute(name = "xmlns")
    private final String xmlns;

    @JsonIgnore
    @Override
    public String getExpectedXmlns() {
        return SCHEMA;
    }

    @JsonIgnore
    @Override
    public StatusMessage getGenericError() {
        return getError();
    }

    @Override
    public AirShoppingRs withGenericError(StatusMessage error) {
        return toBuilder()
                .error(error)
                .build();
    }

    @JsonPOJOBuilder(withPrefix = "")
    @JsonIgnoreProperties({"xmlns:xsi", "xsi:schemaLocation"})
    @SuppressWarnings("unused")
    public static class AirShoppingRsBuilder {
        @XmlAttribute(name = "xmlns")
        private String xmlns;
    }
}
