package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotTicketCouponStatusCode;

@Value
@Builder
@JsonDeserialize(builder = Coupon.CouponBuilder.class)
public class Coupon {
    private final String baggageAllowanceRefID;
    private final String couponNumber;
    private final AeroflotTicketCouponStatusCode couponStatusCode;
    private final String fareBasisCode;
    private final String remarkText;
    private final String serviceRefID;
    private final SoldAirlineInfo soldAirlineInfo;

    @JsonPOJOBuilder(withPrefix = "")
    public static class CouponBuilder {
    }
}
