package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = DataLists.DataListsBuilder.class)
public class DataLists {
    @XmlElementWrapper(name = "BaggageAllowanceList")
    @XmlElement(name = "BaggageAllowance")
    private final List<BaggageAllowance> baggageAllowanceList;

    @XmlElementWrapper(name = "ContactInfoList")
    @XmlElement(name = "ContactInfo")
    private final List<ContactInfo> contactInfoList;

    @XmlElementWrapper(name = "OriginDestList")
    @XmlElement(name = "OriginDest")
    private final List<OriginDest> originDestList;

    @XmlElementWrapper(name = "PaxJourneyList")
    @XmlElement(name = "PaxJourney")
    private final List<PaxJourney> paxJourneyList;

    @XmlElementWrapper(name = "PaxList")
    @XmlElement(name = "Pax")
    private final List<Pax> paxList;

    @XmlElementWrapper(name = "PaxSegmentList")
    @XmlElement(name = "PaxSegment")
    private final List<PaxSegment> paxSegmentList;

    @XmlElementWrapper(name = "PriceClassList")
    @XmlElement(name = "PriceClass")
    private final List<PriceClass> priceClassList;

    @XmlElementWrapper(name = "SeatProfileList")
    @XmlElement(name = "SeatProfile")
    private final List<SeatProfile> seatProfileList;

    @XmlElementWrapper(name = "ServiceDefinitionList")
    @XmlElement(name = "ServiceDefinition")
    private final List<ServiceDefinition> serviceDefinitionList;

    @XmlElementWrapper(name = "TermsList")
    @XmlElement(name = "Term")
    private final List<Term> termsList;

    @JsonPOJOBuilder(withPrefix = "")
    @SuppressWarnings("unused")
    public static class DataListsBuilder {
        @XmlElementWrapper(name = "BaggageAllowanceList")
        @XmlElement(name = "BaggageAllowance")
        private List<BaggageAllowance> baggageAllowanceList;

        @XmlElementWrapper(name = "ContactInfoList")
        @XmlElement(name = "ContactInfo")
        private List<ContactInfo> contactInfoList;

        @XmlElementWrapper(name = "OriginDestList")
        @XmlElement(name = "OriginDest")
        private List<OriginDest> originDestList;

        @XmlElementWrapper(name = "PaxJourneyList")
        @XmlElement(name = "PaxJourney")
        private List<PaxJourney> paxJourneyList;

        @XmlElementWrapper(name = "PaxList")
        @XmlElement(name = "Pax")
        private List<Pax> paxList;

        @XmlElementWrapper(name = "PaxSegmentList")
        @XmlElement(name = "PaxSegment")
        private List<PaxSegment> paxSegmentList;

        @XmlElementWrapper(name = "PriceClassList")
        @XmlElement(name = "PriceClass")
        private List<PriceClass> priceClassList;

        @XmlElementWrapper(name = "SeatProfileList")
        @XmlElement(name = "SeatProfile")
        private List<SeatProfile> seatProfileList;

        @XmlElementWrapper(name = "ServiceDefinitionList")
        @XmlElement(name = "ServiceDefinition")
        private List<ServiceDefinition> serviceDefinitionList;

        @XmlElementWrapper(name = "TermsList")
        @XmlElement(name = "Term")
        private List<Term> termsList;
    }
}
