package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonDeserialize(builder = FareComponent.FareComponentBuilder.class)
public class FareComponent {
    private final CabinType cabinType;
    private final String fareBasisCode;
    private final String paxSegmentRefID;
    private final String priceClassRefID;
    @JsonProperty("RBD")
    private final RBD rbd;

    @JsonPOJOBuilder(withPrefix = "")
    @SuppressWarnings("unused")
    public static class FareComponentBuilder {
    }
}
