package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = FarePriceType.FarePriceTypeBuilder.class)
public class FarePriceType {
    public static final String DEFAULT_PRICE_TYPE_CODE = "Sell";

    private final String farePriceTypeCode;
    private final PriceDetalization price;

    @JsonPOJOBuilder(withPrefix = "")
    public static class FarePriceTypeBuilder {
    }
}
