package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@AllArgsConstructor
@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = GenderCode.GenderCodeDeserializer.class)
public enum GenderCode implements ValueBasedEnum<String> {
    MALE("M"),
    FEMALE("F");

    private final String value;

    static class GenderCodeDeserializer extends ValueBasedEnumDeserializationConverter<String, GenderCode> {
    }
}
