package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = IdentityDoc.IdentityDocBuilder.class)
public class IdentityDoc {
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private final LocalDate birthdate;
    private final String citizenshipCountryCode;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private final LocalDate expiryDate;
    private final String identityDocID;
    private final IdentityDocType identityDocTypeCode;
    private final String issuingCountryCode;

    @JsonPOJOBuilder(withPrefix = "")
    public static class IdentityDocBuilder {
    }
}
