package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = Individual.IndividualBuilder.class)
public class Individual {
    private final GenderCode genderCode;
    private final String givenName;
    private final String individualID;
    private final String middleName;
    private final SuffixName suffixName;
    private final String surname;

    @JsonPOJOBuilder(withPrefix = "")
    public static class IndividualBuilder {
    }
}
