package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = MarketingCarrierInfo.MarketingCarrierInfoBuilder.class)
public class MarketingCarrierInfo {
    private final String carrierDesigCode;
    private final String carrierName;
    private final String marketingCarrierFlightNumberText;

    @JsonPOJOBuilder(withPrefix = "")
    public static class MarketingCarrierInfoBuilder {
    }
}
