package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = MoneyAmount.MoneyAmountBuilder.class)
public class MoneyAmount {
    @JacksonXmlText
    private final BigDecimal value;
    @JacksonXmlProperty(isAttribute = true)
    private final String curCode;

    @JsonPOJOBuilder(withPrefix = "")
    @SuppressWarnings("unused")
    public static class MoneyAmountBuilder {
    }
}
