package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Offer.OfferBuilder.class)
public class Offer {
    private final List<BaggageAllowanceRef> baggageAllowance;
    private final String offerID;
    private final List<OfferItem> offerItem;
    private final String ownerCode;
    private final String ownerTypeCode;
    private final PriceDetalization totalPrice;
    private final String webAddressURL;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OfferBuilder {
    }
}
