package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JacksonXmlRootElement(localName = "IATA_OfferPriceRQ")
public class OfferPriceRq {
    // see the javadoc to AirShoppingRq.xmlns
    @JacksonXmlProperty(isAttribute = true, localName = "xmlns")
    private final String xmlns = "http://www.iata.org/IATA/2015/00/2018.2/IATA_OfferPriceRQ";

    private final Party party;
    private final PayloadAttributes payloadAttributes;
    private final PointOfSale pointOfSale;
    private final OfferPriceRqBody request;
}
