package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import javax.xml.bind.annotation.XmlAttribute;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = OfferPriceRs.OfferPriceRsBuilder.class)
public class OfferPriceRs implements ApiDataXmlRoot<OfferPriceRs> {
    public static final String SCHEMA = "http://www.iata.org/IATA/2015/00/2018.2/IATA_OfferPriceRS";

    private final OfferPriceRsBody response;
    private final MessageDoc messageDoc;
    private final StatusMessage error;
    private final PayloadAttributes payloadAttributes;
    @XmlAttribute(name = "xmlns")
    private final String xmlns;

    @JsonIgnore
    @Override
    public String getExpectedXmlns() {
        return SCHEMA;
    }

    @JsonIgnore
    @Override
    public StatusMessage getGenericError() {
        return getError();
    }

    @Override
    public OfferPriceRs withGenericError(StatusMessage error) {
        return toBuilder()
                .error(error)
                .build();
    }

    @JsonPOJOBuilder(withPrefix = "")
    @SuppressWarnings("unused")
    public static class OfferPriceRsBuilder {
        @XmlAttribute(name = "xmlns")
        private String xmlns;
        private MessageDoc messageDoc;
    }
}
