package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = OperatingCarrierInfo.OperatingCarrierInfoBuilder.class)
public class OperatingCarrierInfo {
    private final String carrierDesigCode;
    private final Disclosure disclosure;
    private final String operatingCarrierFlightNumberText;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OperatingCarrierInfoBuilder {
    }
}
