package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonDeserialize(builder = Order.OrderBuilder.class)
public class Order {
    private final String orderID;
    private final List<OrderItem> orderItem;
    private final String ownerCode;
    private final OrderTotalPrice totalPrice;
    private final String webAddressURI;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OrderBuilder {
    }
}
