package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.time.Instant;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonDeserialize(builder = OrderItem.OrderItemBuilder.class)
public class OrderItem {
    private final FareDetail fareDetail;
    private final String orderItemID;
    private final String ownerCode;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private final Instant paymentTimeLimitDateTime;
    // some empty element
    private final Object price;
    private final List<OrderService> service;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OrderItemBuilder {
    }
}
