package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JacksonXmlRootElement(localName = "IATA_OrderRetrieveRQ")
public class OrderRetrieveRq {
    // see the javadoc to AirShoppingRq.xmlns
    @JacksonXmlProperty(isAttribute = true, localName = "xmlns")
    private final String xmlns = "http://www.iata.org/IATA/2015/00/2018.2/IATA_OrderRetrieveRQ";

    private final Party party;
    private final PayloadAttributes payloadAttributes;
    private final OrderRetrieveRqBody request;
}
