package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = OrderViewRs.OrderViewRsBuilder.class)
public class OrderViewRs implements ApiDataXmlRoot<OrderViewRs> {
    public static final String SCHEMA = "http://www.iata.org/IATA/2015/00/2018.2/IATA_OrderViewRS";

    private final OrderViewRsBody response;
    private final MessageDoc messageDoc;
    private final OrderViewRsError error;
    private final PayloadAttributes payloadAttributes;
    private final PaymentInfo paymentInfo;
    @JacksonXmlProperty(isAttribute = true, localName = "xmlns")
    private final String xmlns;

    @JsonIgnore
    @Override
    public String getExpectedXmlns() {
        return SCHEMA;
    }

    @JsonIgnore
    @Override
    public StatusMessage getGenericError() {
        return error != null ? error.getError() : null;
    }

    @Override
    public OrderViewRs withGenericError(StatusMessage error) {
        OrderViewRsError errorWrapper = this.error != null ? this.error : OrderViewRsError.builder().build();
        return toBuilder()
                .error(errorWrapper.toBuilder()
                        .error(error)
                        .build())
                .build();
    }

    @JsonPOJOBuilder(withPrefix = "")
    @SuppressWarnings("unused")
    public static class OrderViewRsBuilder {
    }
}
