package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@AllArgsConstructor
@JsonPropertyOrder({"destCode", "originCode", "originDestID", "PaxJourneyRefID"})
@JsonDeserialize(builder = OriginDest.OriginDestBuilder.class)
public class OriginDest {
    private final String originDestID;
    private final String originCode;
    private final String destCode;
    private final List<String> paxJourneyRefID;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OriginDestBuilder {
    }
}
