package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.MultiEnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@AllArgsConstructor
@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = PTC.PTCDeserializer.class)
public enum PTC implements ValueBasedEnum<String> {
    ADULT("ADT"),
    CHILD("CHD"),
    INFANT("INF");

    private final String value;

    static class PTCDeserializer extends ValueBasedEnumDeserializationConverter<String, PTC> {
    }

    public static PTC forValue(String value) {
        return MultiEnumIndex.getGlobal().get(PTC.class).getByValue(value);
    }
}
