package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = Pax.PaxBuilder.class)
public class Pax {
    private final String contactInfoRefID;
    private final IdentityDoc identityDoc;
    private final Individual individual;
    private final LoyaltyProgramAccount loyaltyProgramAccount;
    private final String paxID;
    private final String paxRefID;
    @JsonProperty("PTC")
    private final PTC ptc;

    @JsonPOJOBuilder(withPrefix = "")
    @SuppressWarnings("unused")
    public static class PaxBuilder {
    }
}
