package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.time.Duration;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = PaxJourney.PaxJourneyBuilder.class)
public class PaxJourney {
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private final Duration duration;
    private final String paxJourneyID;
    private final List<String> paxSegmentRefID;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PaxJourneyBuilder {
    }
}
