package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.time.Duration;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonDeserialize(builder = PaxSegment.PaxSegmentBuilder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PaxSegment {
    private final ScheduledLocation arrival;
    private final DatedOperatingLeg datedOperatingLeg;
    private final ScheduledLocation dep;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private final Duration duration;
    private final MarketingCarrierInfo marketingCarrierInfo;
    private final OperatingCarrierInfo operatingCarrierInfo;
    private final String paxSegmentID;
    private final String segmentTypeCode;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PaxSegmentBuilder {
    }
}
