package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.time.Instant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonDeserialize(builder = PayloadAttributes.PayloadAttributesBuilder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PayloadAttributes {
    private final String correlationID;
    private final String primaryLangID;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private final Instant timestamp;
    private final String versionNumber;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PayloadAttributesBuilder {
    }
}
