package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = PaymentCard.PaymentCardBuilder.class)
public class PaymentCard {
    private final String cardBrandCode;
    private final String cardNumber;
    private final PaymentInstructions securePayerAuthenticationInstructions;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PaymentCardBuilder {
    }
}
