package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = PaymentInfo.PaymentInfoBuilder.class)
public class PaymentInfo {
    private final MoneyAmount amount;
    private final String paymentInfoID;
    private final PaymentMethod paymentMethod;
    private final PaymentTrx paymentTrx;
    private final PaymentType typeCode;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PaymentInfoBuilder {
    }
}
