package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonDeserialize(builder = PaymentInstructions.PaymentInstructionsBuilder.class)
public class PaymentInstructions {
    private final String terminationURL;
    private final String payerAuthenticationRequestText;
    private final String redirectionURL;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PaymentInstructionsBuilder {
    }
}
