package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = PaymentMethod.PaymentMethodBuilder.class)
public class PaymentMethod {
    private final PaymentCard paymentCard;

    public static PaymentMethod createRedirectInstructions(String paymentRedirectUrl) {
        return new PaymentMethod(PaymentCard.builder()
                .securePayerAuthenticationInstructions(PaymentInstructions.builder()
                        .terminationURL(paymentRedirectUrl)
                        .build())
                .build());
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class PaymentMethodBuilder {
    }
}
