package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@AllArgsConstructor
@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = PaymentType.PaymentTypeDeserializationConverter.class)
public enum PaymentType implements ValueBasedEnum<String> {
    CREDIT_CARD("CC");

    private final String value;

    static class PaymentTypeDeserializationConverter
            extends ValueBasedEnumDeserializationConverter<String, PaymentType> {
    }
}
