package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = PieceAllowance.PieceAllowanceBuilder.class)
public class PieceAllowance {
    private final String applicablePartyText;
    private final List<PieceDimensionAllowance> pieceDimensionAllowance;
    private final PieceWeightAllowance pieceWeightAllowance;
    // some empty element
    private final Object desc;
    private final Integer totalQty;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PieceAllowanceBuilder {
    }
}
