package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = PriceClass.PriceClassBuilder.class)
public class PriceClass {
    private final String code;
    private final List<PriceClassDesc> desc;
    private final String fareBasisCode;
    private final String name;
    private final String priceClassID;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PriceClassBuilder {
    }
}
