package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = PriceClassDesc.PriceClassDescBuilder.class)
public class PriceClassDesc {
    @JsonProperty("URL")
    private final String url;
    private final String descText;

    @JsonPOJOBuilder(withPrefix = "")
    @SuppressWarnings("unused")
    public static class PriceClassDescBuilder {
    }
}
