package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PriceDetalization.PriceDetalizationBuilder.class)
public class PriceDetalization {
    private final MoneyAmount baseAmount;
    private final MoneyAmount equivAmount;
    private final List<TaxSummary> taxSummary;
    private final MoneyAmount totalAmount;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PriceDetalizationBuilder {
    }
}
