package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import org.apache.logging.log4j.util.Strings;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = ScheduledLocation.ScheduledLocationBuilder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"aircraftScheduledDateTime", "iataLocationCode", "stationName", "terminalName"})
public class ScheduledLocation {
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private final LocalDateTime aircraftScheduledDateTime;
    @JsonProperty("IATALocationCode")
    private final String iataLocationCode;
    private final String stationName;
    private final String terminalName;

    @JsonPOJOBuilder(withPrefix = "")
    @SuppressWarnings("unused")
    public static class ScheduledLocationBuilder {
        protected ScheduledLocationBuilder() {
        }

        protected ScheduledLocationBuilder(String emptyNodeContent) {
            Preconditions.checkArgument(Strings.isBlank(emptyNodeContent),
                    "Unexpected location content: %s", emptyNodeContent);
        }
    }
}
