package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonDeserialize(builder = ServiceDefinition.ServiceDefinitionBuilder.class)
public class ServiceDefinition {
    private final ServiceDefinitionDesc desc;
    private final String name;
    private final String ownerCode;
    private final String serviceCode;
    private final String serviceDefinitionID;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ServiceDefinitionBuilder {
    }
}
