package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@AllArgsConstructor
@JsonDeserialize(builder = StatusMessage.StatusMessageBuilder.class)
public class StatusMessage {
    private final String code;
    private final String descText;
    private final String langCode;
    private final String typeCode;

    // these fields aren't deserialized directly but parsed via regexp-s
    @JsonIgnore
    private final String customType;
    @JsonIgnore
    private final String customComment;

    public String describe() {
        String description = "Error code: " + code  + ", text: " + descText;
        if (customType != null) {
            description += ", custom message: [" + customType + ": " + customComment + "]";
        }
        return description;
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class StatusMessageBuilder {
    }
}
