package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@AllArgsConstructor
@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
public enum SuffixName implements ValueBasedEnum<String> {
    I("I"),
    II("II"),
    III("III"),
    IV("IV"),
    SENIOR("Sr"),
    JUNIOR("Jr");

    private final String value;

    private final static EnumIndex<String, SuffixName> index = EnumIndex.create(SuffixName.class);

    public static SuffixName forValue(String value) {
        return index.getByValue(value);
    }
}
