package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = Tax.TaxBuilder.class)
public class Tax {
    private final MoneyAmount amount;
    private final String descText;
    private final String qualifierCode;
    private final String taxCode;

    @JsonPOJOBuilder(withPrefix = "")
    public static class TaxBuilder {
    }
}
