package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = TaxSummary.TaxSummaryBuilder.class)
public class TaxSummary {
    private final List<Tax> tax;
    private final MoneyAmount totalTaxAmount;

    @JsonPOJOBuilder(withPrefix = "")
    public static class TaxSummaryBuilder {
    }
}
