package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@AllArgsConstructor
@JsonDeserialize(builder = TermDesc.TermDescBuilder.class)
public class TermDesc {
    private final String descText;
    @JsonProperty("URL")
    private final String url;

    @JsonPOJOBuilder(withPrefix = "")
    @SuppressWarnings("unused")
    public static class TermDescBuilder {
    }
}
