package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotTicketDocTypeCode;

@Value
@Builder
@JsonDeserialize(builder = Ticket.TicketBuilder.class)
public class Ticket {
    private final List<Coupon> coupon;
    private final AeroflotTicketDocTypeCode ticketDocTypeCode;
    private final String ticketNumber;

    @JsonPOJOBuilder(withPrefix = "")
    public static class TicketBuilder {
    }
}
