package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonDeserialize(builder = TicketDocInfo.TicketDocInfoBuilder.class)
public class TicketDocInfo {
    private final BookingAgency bookingAgency;
    private final BookingRef bookingRef;
    private final String endorsementText;
    private final FareDetail fareDetail;
    private final String paxRefID;
    private final String paymentInfoRefID;
    private final Ticket ticket;

    @JsonPOJOBuilder(withPrefix = "")
    public static class TicketDocInfoBuilder {
    }
}
