package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.requests;

import lombok.Getter;

@Getter
public class AeroflotNdcApiV3ApiResponseException extends RuntimeException {
    private static final int MAX_MESSAGE_DATA_LENGTH = 1024;

    private final String data;

    private AeroflotNdcApiV3ApiResponseException(String data, String message, Throwable cause) {
        super(message);
        this.data = data;
    }

    public static AeroflotNdcApiV3ApiResponseException createTruncated(String data, String reason) {
        return new AeroflotNdcApiV3ApiResponseException(data, truncatedMessage(data, reason), null);
    }

    public static AeroflotNdcApiV3ApiResponseException createTruncated(String data, Throwable cause) {
        return new AeroflotNdcApiV3ApiResponseException(data, truncatedMessage(data, cause.getMessage()), cause);
    }

    private static String truncatedMessage(String data, String reason) {
        int maxLen = Math.min(data.length(), MAX_MESSAGE_DATA_LENGTH);
        String dataSample = data.substring(0, maxLen) + (maxLen < data.length() ? "..." : "");
        return "Received bad API response; reason: " + reason + ", data: " + dataSample;
    }
}
