package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.requests;

import java.io.IOException;
import java.util.Arrays;

import javax.xml.stream.XMLStreamException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import com.google.common.base.Preconditions;
import org.codehaus.stax2.XMLStreamWriter2;

/**
 * A slightly generalized (N-spaces) copy-paste of {@linkplain DefaultXmlPrettyPrinter.Lf2SpacesIndenter}
 */
@SuppressWarnings({"JavadocReference", "CatchMayIgnoreException", "unused"})
public class LfNSpacesIndenter implements DefaultXmlPrettyPrinter.Indenter, java.io.Serializable {
    private static final long serialVersionUID = 1L;

    final static String SYSTEM_LINE_SEPARATOR;

    static {
        String lf = null;
        try {
            lf = System.getProperty("line.separator");
        } catch (Throwable t) {
        } // access exception?
        SYSTEM_LINE_SEPARATOR = (lf == null) ? "\n" : lf;
    }

    final static int SPACE_COUNT = 64;
    final static char[] SPACES = new char[SPACE_COUNT];

    static {
        Arrays.fill(SPACES, ' ');
    }

    private final int spacesPerLevel;

    public LfNSpacesIndenter(int spacesPerLevel) {
        Preconditions.checkArgument(spacesPerLevel >= 0,
                "spacesPerLevel should not be negative but got %s", spacesPerLevel);
        this.spacesPerLevel = spacesPerLevel;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public void writeIndentation(XMLStreamWriter2 sw, int level) throws XMLStreamException {
        sw.writeRaw(SYSTEM_LINE_SEPARATOR);
        level += (spacesPerLevel - 1) * level; // N spaces per level
        while (level > SPACE_COUNT) { // should never happen but...
            sw.writeRaw(SPACES, 0, SPACE_COUNT);
            level -= SPACES.length;
        }
        sw.writeRaw(SPACES, 0, level);
    }

    @Override
    public void writeIndentation(JsonGenerator jg, int level) throws IOException {
        jg.writeRaw(SYSTEM_LINE_SEPARATOR);
        level += (spacesPerLevel - 1) * level; // N spaces per level
        while (level > SPACE_COUNT) { // should never happen but...
            jg.writeRaw(SPACES, 0, SPACE_COUNT);
            level -= SPACES.length;
        }
        jg.writeRaw(SPACES, 0, level);
    }
}

